#include "demodata.h"
#include "msglog.h"
#include <string.h>
#include <stdio.h>
#include <stdarg.h>

demodata::demodata() 
{
	time = 0;
	oldframe = 0;
	first = new demodata_t[1];
	first->next = 0;
	first->id = 0;
	last = first;
	current = first;
	changed = false;
}

demodata::~demodata() 
{
	demodata_t* next;
	current = first->next;
	for (;;) {
		if (current == 0) break;
		switch (current->type) {
		case 222:
		case 223:
			delete[] current->vp_int;
			break;
		case 111:
			delete[] current->vp_float;
			delete[] current->vp_int;
			break;
		default:
			delete[] current->message;
			delete[] current->vp_int;
			break;
		}
		next = current->next;
		delete[] current;
		current = next;
	}
	delete[] first;
}

void demodata::add (unsigned int frame, int type, ...) 
{
	int i;
	char* tempstr;
	float* tempfloat;
	va_list arglist;
	va_start (arglist, type);
	last->next = new demodata_t[1];
	last->next->id = last->id + 1;
	last = last->next;
	last->next = 0;
	last->used = false;
	last->frame = frame;
	last->type = type;
	// time tracking
	if (type != 100) {
		time += frame - oldframe;
	}
	last->time = time;
	oldframe = frame;
	//-- time tracking
	switch (type) {
	case 222:
		int quad_entity;
		last->vp_int = new int[1];
		last->vp_int[0] = va_arg (arglist, int);
		break;
	case 111:
		last->vp_float = new float[3];
		last->vp_int = new int[1];
		for (i = 0; i < 3; i++) {
			tempfloat = va_arg (arglist, float*);
			last->vp_float[i] = (*tempfloat);
		}
		last->vp_int[0] = va_arg (arglist, int);
		break;
	default:
		tempstr = va_arg (arglist, char*);
		last->message = new char[strlen (tempstr)+1];
		strcpy (last->message, tempstr);
		last->vp_int = new int[1];
		last->vp_int[0] = va_arg (arglist, int);
		break;
	}
	last->killer = -1;
	last->victim = -1;
	last->weapon = -1;
	changed = true;
	va_end (arglist);
}

void demodata::build_next_of_type_list () 
{
	current = first->next;
	while (current != 0) {
		current->next_of_type = 0;
		demodata_t* search = current->next;
		while (search != 0) {
			if (search->type == current->type) {
				current->next_of_type = search;
				break;
			} else {
				search = search->next;
			}
		}
		current = current->next;
	}
}

demodata_t* demodata::get_first () 
{
	if (changed == true) { 
		build_next_of_type_list ();
		changed = false;
	}
	current = first->next;
	return current;
}

demodata_t* demodata::get_first_of_type (int type) 
{
	if (changed == true) { 
		build_next_of_type_list ();
		changed = false;
	}
	current = first->next;
	while ((current != 0) && (current->type != type)) current = current->next;
	return current;
}


demodata_t* demodata::get_last()
{
	return last;
}
